<?php
/**
 * Outputs markup for Generic KPIs
 *
 * @package EDD_Enhanced_Sales_Reports
 * @version 1.0.0
 * */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo number_format( $total_products_sold, 0 ); ?></strong>
	<span><?php esc_html_e( 'Products Sold', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo number_format( $total_sales, 0 ); ?></strong>
	<span><?php esc_html_e( 'Unique Orders', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo number_format( $total_customers, 0 ); ?></strong>
	<span><?php esc_html_e( 'Customers', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo number_format( $total_countries, 0 ); ?></strong>
	<span><?php esc_html_e( 'Countries', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo number_format( $total_authors, 0 ); ?></strong>
	<span><?php esc_html_e( 'Authors', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo esc_html( $currency ) . number_format( $total_earnings, 2 ); ?></strong>
	<span><?php esc_html_e( 'Gross Earnings', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo number_format( $orders_with_discounts, 0 ); ?></strong>
	<span><?php esc_html_e( 'Discount Codes Used', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo esc_html( $currency ) . number_format( $total_discounts, 2 ); ?></strong>
	<span><?php esc_html_e( 'Total Discounts', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo esc_html( $currency ) . number_format( $total_tax, 2 ); ?></strong>
	<span><?php esc_html_e( 'Total Tax', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo esc_html( $currency ) . number_format( $total_earnings - $total_tax - $total_discounts, 2 ); ?></strong>
	<span><?php esc_html_e( 'Net Earnings', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo esc_html( $currency ) . number_format( $aov_kpi, 2 ); ?></strong>
	<span><?php esc_html_e( 'AOV', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo number_format( $total_new_customers, 0 ); ?></strong>
	<span><?php esc_html_e( 'New Customers', 'edd-enhanced-sales-reports' ); ?></span>
</div>
<div class="edd-enhanced-sales-reports-kpi">
	<strong><?php echo esc_html( str_replace( '.0', '', $total_paid_percentage ) ); ?></strong>
	<span><?php esc_html_e( 'Paid', 'edd-enhanced-sales-reports' ); ?></span>
</div>
